# Chrome Web Store Publishing Guide

## Prerequisites
1. Google Developer account ($5 one-time fee): https://chrome.google.com/webstore/devconsole
2. Extension ZIP file (no node_modules, no .git)
3. Store listing assets:
   - Icon: 128x128 PNG
   - Screenshots: 1280x800 or 640x400 (min 1, max 5)
   - Promotional tile: 440x280 (optional but recommended)
   - Description (up to 16,000 chars)

## Steps
1. Create developer account at https://chrome.google.com/webstore/devconsole
2. Pay $5 registration fee
3. Click "New Item" → upload ZIP
4. Fill in listing details (see below)
5. Submit for review (typically 1-3 business days)

## Listing Details

**Name:** WhatnotFlow — Live Show Fulfillment
**Short description:** Real-time bin assignment for Whatnot sellers. Never sort packages again.
**Category:** Productivity
**Language:** English

**Description:**
WhatnotFlow automatically captures every sale during your Whatnot live shows and assigns buyers to physical bins for easy packing and shipping.

🔥 How it works:
1. Install the extension
2. Start a show on your WhatnotFlow dashboard
3. Go live on Whatnot
4. Every sale is instantly captured and assigned a bin number
5. After the show, pack and ship by bin — no sorting needed

⚡ Features:
• Real-time sale capture — zero delay
• Automatic bin assignment for every buyer
• Audio callouts when new buyers join
• Post-show packing summary with box size suggestions
• Works with ANY Whatnot seller account
• No API keys or developer setup needed

💰 Built by Whatnot sellers, for Whatnot sellers.

**Privacy:** This extension only activates on whatnot.com live show pages. It reads sale data from the page to enable bin assignment. No data is collected, stored, or shared with third parties. Sales data is sent only to your own WhatnotFlow server.
