const sharp = require('sharp');
const path = require('path');

const sizes = [16, 32, 48, 128];

async function generate() {
  for (const size of sizes) {
    const r = Math.round(size * 0.18);
    const p = Math.round(size * 0.08);
    const ir = Math.round(size * 0.12);
    const fs = Math.round(size * 0.45);
    
    const svg = `<svg xmlns="http://www.w3.org/2000/svg" width="${size}" height="${size}">
      <rect width="${size}" height="${size}" rx="${r}" fill="#ff4500"/>
      <rect x="${p}" y="${p}" width="${size-p*2}" height="${size-p*2}" rx="${ir}" fill="#cc3700"/>
      <text x="${size/2}" y="${size*0.72}" text-anchor="middle" font-size="${fs}" font-weight="900" font-family="Arial,sans-serif" fill="white">⚡</text>
    </svg>`;
    
    await sharp(Buffer.from(svg))
      .png()
      .toFile(path.join(__dirname, `icon${size}.png`));
    
    console.log(`✅ icon${size}.png`);
  }
  console.log('Done!');
}

generate().catch(console.error);
